/*----------------------------------------------------------------------
	make_hidlin.c
	
	Creates a grid of elevations and then
	input file for the 3D hidden line algorithm (hidlinpix)
	
	The input file creation process is fully explained in Ammeraal's
	book "Programming Principle in Computer Graphics"
	
	William May
	303A Ridgefield Cirlce
	Clinton, MA 01510
	
	created:	3/20/87
  ----------------------------------------------------------------------*/

#include <stdio.h>
#include "make_hidlin.h"
#include "contour.h"

#define SCALE 100.0

int grid[HMAX][VMAX];
FILE *fp;

/*------------------------------------------------------------------------
	Coordinate creating an input file for hidlinpix
  ------------------------------------------------------------------------*/
make_hidlin()
{
	printf("Beginning make_hidlin\n");
	
	init_grid();

	make_grid();
	
	fp = fopen("grid.dat", "w");

	/* convert grid to hidlin input format */
	conv_hidlin();

	printf("Conversion complete\n");
	
	fclose(fp);
}

/*------------------------------------------------------------------------
	0 the grid
	this may be unnecessary for a global, but doesn't hurt
	It is however, necessary if the contour analysis is
	done repeatedly without quitting the program
  ------------------------------------------------------------------------*/
init_grid()
{
	register int h,v;
	
	for (h = 0; h < HMAX; h++)
		for (v=0; v < VMAX; v++)
			grid[h][v] = 0;
}

/*------------------------------------------------------------------------
	Convert the grid to a hidlinpix input file
	This function is based on code from Ammeraal's book for
	doing 3D projections of mathematical functions
  ------------------------------------------------------------------------*/
conv_hidlin()
{
	int i, j, k, l;
	double f();
							
	fprintf(fp, "%lf %lf %lf\n", (double)HMAX / 2.0, (double)VMAX / 2.0, 0.0);
	
	printf("Printing the point coordinates\n");
	
	for (i = 0; i < HMAX; i++) {
		for (j = 0; j < VMAX; j++) {				
			fprintf(fp, "%d %lf %lf %lf\n", j*(HMAX+1)+i+1,
				(double)i, (double)j, f(i,j));
		}
	}

	fprintf(fp, "Faces:\n");
	
	printf("Printing the faces\n");
	
	/* next two lines switched */
	for (i = 0; i < HMAX; i++) {
		for (j = 0; j < VMAX; j++) {	
			k = j*(HMAX+1)+i+1;
			l = k+HMAX+1;
			fprintf(fp, "%d %d %d#\n", k, -(l+1), k+1);
			fprintf(fp, "%d %d %d#\n", k+1, l+1, -k);
			fprintf(fp, "%d %d %d#\n", k, -(l+1), l);
			fprintf(fp, "%d %d %d#\n", l, l+1, -k);
		}
	}
}

/*------------------------------------------------------------------------
	note reversing the h coordinates
	somewhere the grid is being reversed
  ------------------------------------------------------------------------*/
double f(h,v)
int h,v;
{
	return ((double)(grid[HMAX - h - 1][v]) / SCALE);
}
